/**
* \file: daemon.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_CONTROL_DAEMON_FSM_H
#define ALD_CONTROL_DAEMON_FSM_H

#include <stdbool.h>

#include "app_iface/app_iface.h"
#include "ald_types.h"


void daemon_fsm_kickoff(void);

void daemon_fsm_signal_level_change_complete(error_code_t result);

void daemon_fsm_signal_level_change_request(const challenge_response_t *response,
		level_change_request_callback_t callback);

void daemon_fsm_signal_lock_device_request(level_change_request_callback_t callback);

void daemon_fsm_shutdown_request(void);
void daemon_fsm_signal_shutdown_request(void);

#endif
